/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity;

import com.hoshino.cti.Blocks.BlockEntity.GeneralMachineEntity;
import com.hoshino.cti.Blocks.Machine.SodiumCooler;
import com.hoshino.cti.register.CtiBlock;
import com.hoshino.cti.register.CtiBlockEntityType;
import com.hoshino.cti.util.EmptyHandlers;
import com.hoshino.cti.util.ctiEnergyStore;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismGases;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SodiumCoolerEntity
extends GeneralMachineEntity {
    protected int MAX_ENERGY = 2000000000;
    protected int MAX_TRANSFER = 2000000000;
    protected int BASE_ENERGY_PERTICK = 50000000;
    public final ctiEnergyStore ENERGY_STORAGE = new ctiEnergyStore(this.getMaxEnergy(), 0, this.getMaxTransfer()){

        @Override
        public void onEnergyChange() {
            SodiumCoolerEntity.this.m_6596_();
        }
    };
    private final IGasHandler gasHandler = new IGasHandler(){

        public int getTanks() {
            return 0;
        }

        public GasStack getChemicalInTank(int i) {
            return GasStack.EMPTY;
        }

        public void setChemicalInTank(int i, GasStack stack) {
        }

        public long getTankCapacity(int i) {
            return 0L;
        }

        public boolean isValid(int i, GasStack stack) {
            return false;
        }

        public GasStack insertChemical(int i, GasStack stack, Action action) {
            return GasStack.EMPTY;
        }

        public GasStack extractChemical(int i, long l, Action action) {
            return GasStack.EMPTY;
        }
    };
    private LazyOptional<IEnergyStorage> LazyenergyHandler = LazyOptional.empty();
    private LazyOptional<IGasHandler> LazyGasHandler = LazyOptional.empty();

    public SodiumCoolerEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)CtiBlockEntityType.SODIUM_COOLER.get(), blockPos, blockState);
    }

    public int getMaxEnergy() {
        return this.MAX_ENERGY;
    }

    public int getMaxTransfer() {
        return this.MAX_TRANSFER;
    }

    public int getEnergyPerTick() {
        return this.BASE_ENERGY_PERTICK;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ENERGY) {
            return this.LazyenergyHandler.cast();
        }
        Direction locDir = (Direction)this.m_58900_().m_61143_((Property)SodiumCooler.FACING);
        if (capability == Capabilities.GAS_HANDLER && (direction == locDir.m_122427_() || direction == locDir.m_122428_())) {
            return this.LazyGasHandler.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyenergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
        this.LazyGasHandler = LazyOptional.of(() -> this.gasHandler);
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return null;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyenergyHandler.invalidate();
        this.LazyGasHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy_store", this.ENERGY_STORAGE.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.ENERGY_STORAGE.deserializeNBT(nbt.m_128423_("energy_store"));
        super.m_142466_(nbt);
    }

    @Nullable
    public ctiEnergyStore getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, SodiumCoolerEntity entity) {
        GasStack gasStack;
        GasStack stack;
        int a;
        if (level.f_46443_) {
            return;
        }
        if (!state.m_60713_((Block)CtiBlock.sodium_cooler_block.get())) {
            return;
        }
        for (Direction direction : List.of(Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH)) {
            int amount;
            IEnergyStorage storage;
            if (entity.ENERGY_STORAGE.getEnergyStored() <= 0) break;
            BlockEntity energyContainer = level.m_7702_(entity.m_58899_().m_121945_(direction));
            if (energyContainer == null || !energyContainer.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent() || (storage = (IEnergyStorage)energyContainer.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse(null)).receiveEnergy(amount = Math.min(storage.receiveEnergy(entity.ENERGY_STORAGE.getEnergyStored(), true), entity.ENERGY_STORAGE.extractEnergy(entity.ENERGY_STORAGE.getEnergyStored(), true)), true) != amount) continue;
            storage.receiveEnergy(amount, false);
            entity.ENERGY_STORAGE.extractEnergy(amount, false);
        }
        if (entity.ENERGY_STORAGE.getEnergyStored() > entity.ENERGY_STORAGE.getMaxEnergyStored() - entity.getEnergyPerTick()) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockEntity inputContainer = level.m_7702_(blockPos.m_121945_(direction.m_122427_()));
        BlockEntity outputContainer = level.m_7702_(blockPos.m_121945_(direction.m_122428_()));
        if (outputContainer == null || inputContainer == null) {
            return;
        }
        LazyOptional inputOptional = inputContainer.getCapability(Capabilities.GAS_HANDLER, direction.m_122428_());
        LazyOptional outputOptional = outputContainer.getCapability(Capabilities.GAS_HANDLER, direction.m_122427_());
        IGasHandler inputHandler = (IGasHandler)inputOptional.orElse((Object)EmptyHandlers.GAS_EMPTY);
        IGasHandler outputHandler = (IGasHandler)outputOptional.orElse((Object)EmptyHandlers.GAS_EMPTY);
        if (inputHandler.equals(EmptyHandlers.GAS_EMPTY) || outputHandler.equals(EmptyHandlers.GAS_EMPTY)) {
            return;
        }
        Gas Fuel = (Gas)MekanismGases.FISSILE_FUEL.get();
        Gas Waste = (Gas)MekanismGases.NUCLEAR_WASTE.get();
        boolean canInput = false;
        boolean canOutput = false;
        GasStack drain = GasStack.EMPTY;
        GasStack insert = GasStack.EMPTY;
        for (a = 0; a < inputHandler.getTanks(); ++a) {
            stack = (GasStack)inputHandler.getChemicalInTank(a);
            if (stack.getType() != Fuel) continue;
            drain = new GasStack((IGasProvider)Fuel, Math.min(stack.getAmount(), 2870L));
            gasStack = (GasStack)inputHandler.extractChemical((ChemicalStack)drain, Action.SIMULATE);
            if (gasStack.getAmount() > 0L) {
                drain = gasStack;
                canInput = true;
                break;
            }
            drain = GasStack.EMPTY;
        }
        for (a = 0; a < outputHandler.getTanks() && !drain.isEmpty(); ++a) {
            stack = (GasStack)outputHandler.getChemicalInTank(a);
            if (stack.getType() != Waste && !stack.isEmpty()) continue;
            insert = new GasStack((IGasProvider)Waste, Math.min(drain.getAmount(), outputHandler.getTankCapacity(a) - stack.getAmount()));
            gasStack = (GasStack)inputHandler.insertChemical((ChemicalStack)insert, Action.SIMULATE);
            if (gasStack.getAmount() > 0L) {
                insert = gasStack;
                canOutput = true;
                break;
            }
            insert = GasStack.EMPTY;
        }
        if (!canInput || !canOutput) {
            return;
        }
        long amount = Math.min(drain.getAmount(), insert.getAmount());
        float multiplier = (float)amount / 2870.0f;
        drain.setAmount(amount);
        insert.setAmount(amount);
        inputHandler.extractChemical((ChemicalStack)drain, Action.EXECUTE);
        outputHandler.insertChemical((ChemicalStack)insert, Action.EXECUTE);
        entity.ENERGY_STORAGE.setEnergy(entity.ENERGY_STORAGE.getEnergy() + (int)((float)entity.getEnergyPerTick() * multiplier));
        entity.m_6596_();
    }
}

